/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.TextHolder;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class LogoConnectedTextTool
extends TextTool {
    protected int fXValue = 0;
    protected int fYValue = 0;

    public LogoConnectedTextTool(Figure prototype) {
        super(prototype);
        this.fCursorName = "ConnectedTextToolCursor";
        this.loadDefaultFont(prototype);
    }

    protected void loadDefaultFont(Figure prototype) {
        LogoProperties properties = LogoProperties.instance();
        int fontStyle = properties.getIntProperty("font.default.style", 0);
        int fontSize = properties.getIntProperty("font.default.size", 12);
        String fontName = properties.getProperty("font.default.name", "Dialog");
        Color fontColor = new Color(properties.getIntProperty("font.default.color", -16777216));
        TextFigure textFigure = (TextFigure)prototype;
        TextFigure.setCurrentFontColor(fontColor);
        TextFigure.setCurrentFontName(fontName);
        TextFigure.setCurrentFontSize(fontSize);
        TextFigure.setCurrentFontStyle(fontStyle);
    }

    public void activate(DrawingView view) {
        view.setCursor(this.getCursor());
    }

    protected Figure createFigure(DrawingView view) {
        Figure retFigure = super.createFigure(view);
        Figure pressedFigure = view.drawing().findFigure(this.fXValue, this.fYValue);
        TextHolder textHolder = (TextHolder)((Object)retFigure);
        if (pressedFigure != null && textHolder != null && pressedFigure != textHolder) {
            textHolder.connect(pressedFigure);
        }
        return retFigure;
    }

    public void keyDown(KeyEvent evt, int key, DrawingView view) {
        int code = evt.getKeyCode();
        if (code == 27) {
            this.endEdit(view);
        } else {
            super.keyDown(evt, key, view);
        }
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        this.fXValue = x;
        this.fYValue = y;
        view.clearSelection();
        super.mouseDown(e, x, y, view);
    }

    public void mouseMove(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseMove(e, x, y, view);
        if (this.testInputArea(x, y, view)) {
            view.setCursor(Cursor.getDefaultCursor());
        } else {
            view.setCursor(this.fCursor);
        }
    }

    protected boolean testInputArea(int x, int y, DrawingView view) {
        boolean retValue = false;
        retValue = !(view instanceof LogoDrawingViewUDF) || !((LogoDrawingViewUDF)view).canHoldFiugre(new Point(x, y));
        return retValue;
    }
}

